﻿using Hims.Shared.UserModels.NurseShift;
using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProgressReport.Medication
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class TakeModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int Id { get; set; }
        /// <summary>
        /// Gets or sets the by.
        /// </summary>
        /// <value>
        /// The by.
        /// </value>
        public int By { get; set; }

        /// <summary>
        /// Gets or sets the stop reason.
        /// </summary>
        /// <value>
        /// The stop reason.
        /// </value>
        public List<int> InstructionIds { get; set; }

        /// <summary>
        /// Gets or sets the medication date.
        /// </summary>
        /// <value>
        /// The medication date.
        /// </value>
        public DateModel MedicationDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public string? CreatedBy { get; set; }
        /// <summary>
        /// gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        ///// <summary>
        ///// Gets or sets the modified by name.
        ///// </summary>
        ///// <value>
        ///// The created by.
        ///// </value>
        //public int ModifiedByName { get; set; }

    }
}
