﻿#nullable enable
namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The provider availability model.
    /// </summary>
    public class ProviderAvailabilityModel
    {
        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider location name.
        /// </summary>
        public string ProviderLocationName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice location name.
        /// </summary>
        public string PracticeLocationName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice tin.
        /// </summary>
        public string PracticeTIN { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the day name.
        /// </summary>
        public string DayName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the day no.
        /// </summary>
        public int DateNumber { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public char? Status { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string? From24HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string? To24HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string? From12HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string? To12HrsTime { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }


        /// <summary>
        /// Gets or sets the consultation id.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDay { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days.
        /// </summary>
        public int? FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the fee followup days limit.
        /// </summary>
        public int? FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public string? AvailableDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? LeaveStartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? LeaveEndDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool IsLeave { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the no of new patient.
        /// </summary>
        public int? NoOfOfflinePatient { get; set; }
    }
}