﻿using Hims.Domain.Entities;
using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The Reasons model
    /// </summary>
    public class ReasonsModel
    {
        /// <summary>
        /// Gets or sets the Reason  identifier.
        /// </summary>
        /// <value>
        /// The  Reason identifier.
        /// </value>
        public int ReasonsId { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Reasons"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        /// <value>
        /// The modified by name.
        /// </value>
        public string? ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        /// <value>
        /// The login role id.
        /// </value>
        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public string? CreatedByName { get; set;  }
    }
}
