﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class ScanAppointmentNoticeModel
    {
        /// <summary>
        /// Gets or sets the Scan Appointment Notice Id.
        /// </summary>
        public int ScanAppointmentNoticeId { get; set; }

        /// <summary>
        /// Gets or sets the Location Id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Machine Id.
        /// </summary>
        public int? MachineId { get; set; }

        /// <summary>
        /// Gets or sets the From Date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the To Date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the Description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the Active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the Created By.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the Created Date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the Modified By.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the Modified Date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// GEts or sets the provider name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or Sets the modified By Name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the login role
        /// </summary>
        public short? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string? Availability { get; set; }

        /// <summary>
        /// gets or sets the available days.
        /// </summary>
        public string? AvailableDays { get; set; }
    }
}
