﻿using System;

namespace Hims.Shared.UserModels.ServiceOrder.Admission
{
    /// <summary> The chat.</summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the admission pay type.
        /// </summary>
        /// <value>
        /// The name of the admission pay type.
        /// </value>
        public string AdmissionPayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the father or husband
        /// </summary>
        /// <value>
        /// the father or husband
        /// </value>

        public string FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail URL.
        /// </summary>
        /// <value>
        /// The thumbnail URL.
        /// </value>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier.
        /// </summary>
        /// <value>
        /// The unique identifier.
        /// </value>
        public string Guid { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the bed number.
        /// </summary>
        /// <value>
        /// The bed number.
        /// </value>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the room.
        /// </summary>
        /// <value>
        /// The name of the room.
        /// </value>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }


        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        /// <value>
        /// The admission no.
        /// </value>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        /// <value>
        /// The admission time.
        /// </value>
        public TimeSpan AdmissionTime { get; set; }

        /// <summary>
        /// Gets or sets the time string.
        /// </summary>
        /// <value>
        /// The time string.
        /// </value>
        public string TimeString { get; set; }

        /// <summary>
        /// Gets or sets the name of the attendant.
        /// </summary>
        /// <value>
        /// The name of the attendant.
        /// </value>
        public string AttendantName { get; set; }

        /// <summary>
        /// Gets or sets the attendant contact no.
        /// </summary>
        /// <value>
        /// The attendant contact no.
        /// </value>
        public string AttendantContactNo { get; set; }

        /// <summary>
        /// Gets or sets the attendant relation with patient.
        /// </summary>
        /// <value>
        /// The attendant relation with patient.
        /// </value>
        public string AttendantRelationWithPatient { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is discharged.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is discharged; otherwise, <c>false</c>.
        /// </value>
        public bool IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        /// <value>
        /// The provider gender.
        /// </value>
        public string ProviderGender { get; set; } 

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        /// <value>
        /// The patient mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the appointment/admission status.
        /// </summary>
        /// <value>
        /// The appointment/admission status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge time.
        /// </summary>
        public TimeSpan? DischargeTime { get; set; }

        /// <summary>
        /// Gets or sets the time string.
        /// </summary>
        /// <value>
        /// The time string.
        /// </value>
        public string DischargeTimeString { get; set; }

        /// <summary>
        /// Gets or sets the expected discharge date.
        /// </summary>
        /// <value>
        /// The expected discharge date.
        /// </value>
        public DateTime? ExpectedDischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        /// <value>
        /// The street address.
        /// </value>
        public string StreetAddress { get; set; }

        /// <summary>
        /// Gets or sets the address.
        /// </summary>
        /// <value>
        /// The  address.
        /// </value>
        public string AddressLine2 { get; set; }
        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        /// <value>
        /// The city.
        /// </value>
        public string City { get; set; }
        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        /// <value>
        /// The state.
        /// </value>
        public string State { get; set; }
        /// <summary>
        /// Gets or sets the zipcode.
        /// </summary>
        /// <value>
        /// The zipcode.
        /// </value>
        public string Zipcode { get; set; }

        /// <summary>
        /// Gets or sets the zipcode.
        /// </summary>
        /// <value>
        /// The zipcode.
        /// </value>
        public string FullAddress { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string LocationName { get; set; }
       

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeCategoryId { get; set; }
    }
}
