﻿namespace Hims.Shared.UserModels.ServiceOrder
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class AutomaticFilterModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="FilterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [by pass].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [by pass]; otherwise, <c>false</c>.
        /// </value>
        public bool ByPass { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="FilterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
