﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Pharmacy
{
    /// <summary>
    /// The pharmacy department issue header.
    /// </summary>
    public class PharmacyDepartmentIssueHeader
    {

        /// <summary>
        /// Gets or sets the pharmacy department issue header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department issue header identifier.
        /// </value>
        [Key, Identity]
        public long PharmacyDepartmentIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department indent header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent header identifier.
        /// </value>
        public long PharmacyDepartmentIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
    }
}
