﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Inventory;
    using Hims.Shared.UserModels.Pharmacy;

    /// <summary>
    /// The inventory store service interface.
    /// </summary>
    public interface IInventoryStoreService
    {
        /// <summary>
        /// Inserts the inventory ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertInventoryWareHouse(InventoryWareHouseModel model);

        /// <summary>
        /// Updates the inventory ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateInventoryWareHouse(InventoryWareHouseModel model);

        /// <summary>
        /// Fetches all warehouses asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryWareHouseModel>> FetchAllWarehousesAsync(InventoryWareHouseModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateWareHouse(InventoryWareHouseModel model);

        /// <summary>
        /// Modifies the inventory department.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyInventoryDepartment(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches the inventory department asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentModel>> FetchInventoryDepartmentAsync(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches all warehouses based on user asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryWareHouseModel>> FetchAllWarehousesBasedOnUserAsync(InventoryWareHouseModel model);

        /// <summary>
        /// Fetches the inventory department based on user asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentModel>> FetchInventoryDepartmentBasedOnUserAsync(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches the inventory departmental stock asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryDepartmentalStockModel>> FetchInventoryDepartmentalStockAsync(InventoryDepartmentalStockModel model);

        /// <summary>
        /// Adds the inventory product additional details asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddInventoryProductAdditionalDetailsAsync(InventoryProductDetailModel model);

        /// <summary>
        /// Fetches the rack department wise asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryProductRackModel>> FetchRackDepartmentWiseAsync(InventoryProductRackModel model);

        /// <summary>
        /// Adds the department stock consumption asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddDepartmentStockConsumptionAsync(InventoryDepartmentConsumptionModel model);

        /// <summary>
        /// Fetches the departmental consumption products asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<InventoryDepartmentConsumptionModel>> FetchDepartmentalConsumptionProductsAsync(InventoryDepartmentConsumptionModel model);
    }
}