﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.UserExcel;

    /// <summary>
    /// The user excel upload history service interface.
    /// </summary>
    public interface IUserExcelHistoryService
    {
        /// <summary>
        /// The modify excel upload async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyExcelUploadAsync(UserExcelHistoryModel model);

        /// <summary>
        /// The fetch all async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<UserExcelHistoryModel>> FetchAllAsync(UserExcelHistoryModel model);

        /// <summary>
        /// The get single excel history.
        /// </summary>
        /// <param name="userExcelHistoryId">
        /// The excel upload history id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<UserExcelHistoryModel> GetSingleExcelHistory(int userExcelHistoryId);
    }
}
