﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Threading.Tasks;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;

    /// <inheritdoc />
    public class AppointmentExceptionLogServices : IAppointmentExceptionLogService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <summary>
        /// Initializes a new instance of the <see cref="AppointmentExceptionLogServices"/> class.
        /// </summary>
        /// <param name="unitOfWork">
        /// The unit of work.
        /// </param>
        public AppointmentExceptionLogServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task LogAsync(AppointmentExceptionLogModel model)
        {
            var appointmentExceptionLog = new AppointmentExceptionLog
            {
                ExceptionDate = DateTime.Now,
                PaymentStatus = model.PaymentStatus,
                PaymentTransactionId = model.PaymentTransactionId,
                AppointmentId = model.AppointmentId,
                AppointmentLogId = model.AppointmentLogId,
                ExceptionMessage = model.ExceptionMessage,
                StackTrace = model.StackTrace
            };

            return this.unitOfWork.AppointmentExceptionLogs.InsertAsync(appointmentExceptionLog);
        }
    }
}