﻿namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The lab patient parameter model.
    /// </summary>
    public class LabPatientParameterModel
    {
        /// <summary>
        /// Gets or sets the lab patient parameter id.
        /// </summary>
        public int LabPatientParameterId { get; set; }

        /// <summary>
        /// Gets or sets the lab detail id.
        /// </summary>
        public int LabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the test param result.
        /// </summary>
        public string TestParamResult { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the typed by.
        /// </summary>
        public int? TypedBy { get; set; }

        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        public int? LabBookingPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the package name.
        /// </summary>
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? AccountRoleId { get; set; }
    }
}
