﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The Inventory log types.
    /// </summary>
    public enum InventoryLogTypes
    {
        /// <summary>
        /// The Inventory Purchase.
        /// </summary>
        Purchase = 1,

        /// <summary>
        /// The Inventory Return.
        /// </summary>
        Return,

        /// <summary>
        /// The Inventory Indent.
        /// </summary>
        Indent,

        /// <summary>
        /// The Inventory Issue.
        /// </summary>
        Issue,

        /// <summary>
        /// The Inventory Suppliers.
        /// </summary>
        Vendor,

        /// <summary>
        /// The Inventory Companies.
        /// </summary>
        Company,

        /// <summary>
        /// The Inventory Units.
        /// </summary>
        Units,

        /// <summary>
        /// The Inventory Categories.
        /// </summary>
        Categories,

        /// <summary>
        /// The Inventory Racks.
        /// </summary>
        Racks,

        /// <summary>
        /// The Inventory GST.
        /// </summary>
        GST,

        /// <summary>
        /// The Inventory products.
        /// </summary>
        Products,

        /// <summary>
        /// The inventory excel products.
        /// </summary>
        ExcelProducts,

        /// <summary>
        /// The inventory product sheet.
        /// </summary>
        ExcelProductSheet,
        /// <summary>
        /// The inventory product sheet.
        /// </summary>
        Stock,

        /// <summary>
        /// The ware house.
        /// </summary>
        WareHouse
    }
}