﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The indent request model.
    /// </summary>
    public class IndentRequestModel
    {
        /// <summary>
        /// Gets or sets the indent date.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the indent to.
        /// </summary>
        public string IndentTo { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<IndentRequestProductModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the name of the inventory department.
        /// </summary>
        /// <value>
        /// The name of the inventory department.
        /// </value>
        public string InventoryDepartmentName { get; set; }
    }

    /// <summary>
    /// The indent request product model.
    /// </summary>
    public class IndentRequestProductModel
    {
        /// <summary>
        /// Gets or sets the indent detail identifier.
        /// </summary>
        /// <value>
        /// The indent detail identifier.
        /// </value>
        public int IndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the indent header identifier.
        /// </summary>
        /// <value>
        /// The indent header identifier.
        /// </value>
        public int IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the product identifier.
        /// </summary>
        /// <value>
        /// The product identifier.
        /// </value>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }
    }
}
