﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;


    /// <summary>
    /// The department consumption.
    /// </summary>
    public class DepartmentConsumption
    {
        /// <summary>
        /// Gets or sets the department consumption identifier.
        /// </summary>
        /// <value>
        /// The department consumption identifier.
        /// </value>
        [Key, Identity]
        public int DepartmentConsumptionId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy departmental stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy departmental stock identifier.
        /// </value>
        public int PharmacyDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity consumed.
        /// </summary>
        /// <value>
        /// The quantity consumed.
        /// </value>
        public int QuantityConsumed { get; set; }

        /// <summary>
        /// Gets or sets the consumed by.
        /// </summary>
        /// <value>
        /// The consumed by.
        /// </value>
        public int ConsumedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the reason for consumption.
        /// </summary>
        /// <value>
        /// The reason for consumption.
        /// </value>
        public string ReasonForConsumption { get; set; }
    }
}
