﻿using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.Library.Helpers;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{

    using diet = Shared.UserModels.DietEncounter;
    using dietEncounter = Shared.UserModels.DietEncounter;


    public interface IDietEncounterService
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        Task<CommonResponse> AddAsync(diet.InsertModel model);

        /// <summary>
        /// 
        /// </summary>
        /// <param name="appointmentId"></param>
        /// <param name="isAdmission"></param>
        /// <returns></returns>
        Task<DietEncounterModel> FindAsync(int appointmentId, bool isAdmission);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<dietEncounter.DietEncounterResource> FindDashboardAsync(int appointmentId, DietEncounterType type, bool isAdmission);


        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        Task<CommonResponse> UpdateAsync(diet.InsertModel model);

        /// <summary>
        /// 
        /// </summary>
        /// <param name="patientId"></param>
        /// <returns></returns>
        Task<int> FetchVisitNoAsync(int patientId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DietFullTrascriptModel> FindPrescriptionAsync(int appointmentId);
        Task<DietFullTrascriptModel> FindGpla(int? appointmentId);
    }
}
