﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class PatientPaymentModel
    {/// <summary>
     /// Gets or sets the appointment id.
     /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }
        /// <summary>
        /// Gets or sets the other remarks.
        /// </summary>
        /// <value>
        /// The other remarks.
        /// </value>
        public string OtherRemarks { get; set; }
        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        public string? ProviderGender { get; set; }

        /// <summary>
        /// Gets or sets the provider age.
        /// </summary>
        public short? ProviderAge { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the practice name. 
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the provider location.
        /// </summary>
        public string? ProviderLocation { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char? CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string MiddleName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the marital status.
        /// </summary>
        public char? MaritalStatus { get; set; }
        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }
        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }
        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the patient account id.
        /// </summary>
        public int PatientAccountId { get; set; }
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>Gets or sets the provider account id.</summary>
        public int ProviderAccountId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient email.
        /// </summary>
        public string? PatientEmail { get; set; }

        /// <summary>
        /// Gets or sets the provider mobile.
        /// </summary>
        public string? ProviderMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider email.
        /// </summary>
        public string? ProviderEmail { get; set; }

        /// <summary>Gets or sets the enable email alerts.</summary>
        public bool? EnableEmailAlerts { get; set; }

        /// <summary>Gets or sets the enable sms alerts.</summary>
        public bool? EnableSMSAlerts { get; set; }

        /// <summary>Gets or sets the enable desktop notifications.</summary>
        public bool? EnableDesktopNotifications { get; set; }

        /// <summary>Gets or sets the enable mobile notifications.</summary>
        public bool? EnableMobileNotifications { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient country id.
        /// </summary>
        public int PatientCountryId { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the provider country id.
        /// </summary>
        public int ProviderCountryId { get; set; }

        /// <summary>
        /// Gets or sets the provider country code.
        /// </summary>
        public string? ProviderCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the previous appointment no.
        /// </summary>
        public string PreviousAppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the previous admission no.
        /// </summary>
        public string PreviousAdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the previous appointment date.
        /// </summary>
        public DateTime? AppointmentPreviousDate { get; set; }

        /// <summary>
        /// Gets or sets the previous admission discharge date.
        /// </summary>
        public DateTime? AdmissionDischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the previous admission discharge time.
        /// </summary>
        public TimeSpan? AdmissionDischargeTime { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public TimeSpan? AppointmentPreviousTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment date time.
        /// </summary>
        public string? AppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date time.
        /// </summary>
        public string? OldAppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? PreviousAppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the admission discharge TimeString
        /// </summary>
        public string? PreviousAdmissionDischargeTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription.
        /// </summary>
        public bool IsPrescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is full transcript.
        /// </summary>
        public bool IsFullTranscript { get; set; }

        /// <summary>
        /// Gets or sets the patient guid.
        /// </summary>
        public string? PatientGuid { get; set; }

        /// <summary>
        /// Gets or sets the provider guid.
        /// </summary>
        public string? ProviderGuid { get; set; }

        /// <summary>Gets or sets the patient document count.</summary>
        public int? PatientDocumentCount { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? CallStatus { get; set; }

        /// <summary>
        /// Gets or sets the call status text.
        /// </summary>
        public string? CallStatusText { get; set; }

        /// <summary>
        /// Gets or sets the patient call status.
        /// </summary>
        public int? PatientCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the caller name.
        /// </summary>
        public string? CallerName { get; set; }

        /// <summary>
        /// Gets or sets the video call status.
        /// </summary>
        public int? VideoCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? RoomName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? Domain { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is online.
        /// </summary>
        public bool IsOnline { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string? Delay { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the log From.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the doctor message count.
        /// </summary>
        public int? DoctorMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the patient message count.
        /// </summary>
        public int? PatientMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string? DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the UMR number.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient marital status.
        /// </summary>
        public string? PatientMaritalStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment type Id for fetching 
        /// </summary>
        public string? PaymentType { get; set; }

        /// <summary>
        ///  Gets or sets pay Type Name.
        /// </summary>
        public string? PayTypeName { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }
        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? InsuranceCompanyId { get; set; }
        /// <summary>
        ///  Gets or sets is active admission exists.
        /// </summary>
        public bool? IsActiveAdmissionExists { get; set; }

        /// <summary>
        ///  Gets or sets street address.
        /// </summary>
        public string? StreetAddress { get; set; }
        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; } = string.Empty;

        /// <summary>
        ///  Gets or sets city.
        /// </summary>
        public string? City { get; set; }

        /// <summary>
        ///  Gets or sets state.
        /// </summary>
        public string? State { get; set; }

        /// <summary>
        ///  Gets or sets zipcode.
        /// </summary>
        public string? Zipcode { get; set; }

        /// <summary>
        ///  Gets or sets follow up for AppointmentId.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        ///  Gets or sets follow up for admission id.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        public short? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the 
        /// </summary>
        public long? FreeVisitsCount { get; set; }

        /// <summary>
        /// Gets or sets he free follow up days limit.
        /// </summary>
        public int? FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the free follow up days .
        /// </summary>
        public int? FreeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public string? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public string? EndTime { get; set; }

        /// <summary>
        /// Gets or sets AadharNo.
        /// </summary>
        public string? AadharNo { get; set; }

        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }
        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>
        public int? HWCPatientId { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public int? PatientReferredById { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Occupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Nationality { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Religion { get; set; }
        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the checked in.
        /// </summary>
        public DateTime? CheckedIn { get; set; }

        /// <summary>
        /// Gets or sets the checked out.
        /// </summary>
        public DateTime? CheckedOut { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the tat.
        /// </summary>
        public int? Tat { get; set; }


        /// <summary>
        /// Gets or sets the queue status.
        /// </summary>
        /// <value>
        /// The queue status.
        /// </value>
        public string QueueStatus { get; set; }

        /// <summary>
        /// Gets or sets the FatherOrHusband  name.
        /// </summary>
        public string? FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ChargeTypesName { get; set; }

        /// <summary>
        /// Gets or sets 
        /// </summary>
        public int PayType { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the specialization names.
        /// </summary>
        public string? SpecializationNames { get; set; }

        /// <summary>
        /// Gets or sets the languages.
        /// </summary>
        public string? Languages { get; set; }

        /// <summary>
        /// Gets or sets the appointment type id from appointmentType masters.
        /// </summary>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? EducationId { get; set; }
        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }
        /// <summary>
        /// Gets or sets the is referredby.
        /// </summary>
        public string? PatientReferredName { get; set; }

        /// <summary>
        /// Gets or sets the waiting count.
        /// </summary>
        /// <value>
        /// The waiting count.
        /// </value>
        public int? WaitingCount { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? EmailDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? EmailHeadersId { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? ReplyEmailDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the status name.
        /// </summary>
        public string StatusName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment status id.
        /// </summary>
        public int AppointmentStatusId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public bool IsCc { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine ids.
        /// </summary>
        public string? TelemedicineIds { get; set; }
        /// <summary>
        /// Gets or sets the is utc.
        /// </summary>
        public int? CallerRoleId { get; set; }

        /// <summary>
        /// Gets or sets the is utc.
        /// </summary>
        public bool? IsUTC { get; set; }

        /// <summary>
        /// Gets or sets the is specializations.
        /// </summary>
        public string? Specializations { get; set; }

        /// <summary>
        /// Gets or sets the is specializations.
        /// </summary>
        public bool EnableMobileAudioCall { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription blink.
        /// </summary>
        public bool IsPrescriptionBlink { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription blink.
        /// </summary>
        public bool? IsTaskDone { get; set; }

        /// <summary>
        /// Gets or sets the is no of emails.
        /// </summary>
        public int? NoOfEmails { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether Is panic option.
        /// </summary>
        public bool? IsPanicOption { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public DateTime? CallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public DateTime? CallStatusModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the in progress.
        /// </summary>
        /// <value>
        /// The in progress.
        /// </value>
        public bool? InProgress { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? CallType { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallTypeName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? CallerCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallerCallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? ReceiverCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? ReceiverCallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the caller call status date.
        /// </summary>
        public DateTime? CallerCallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the caller call status date.
        /// </summary>
        public DateTime? ReceiverCallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public int? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the is require emergency appointment.
        /// </summary>
        public bool? IsRequireEmergencyAppointment { get; set; }

        /// <summary>
        /// Gets or sets the active users.
        /// </summary>
        public string? ActiveUsers { get; set; }

        /// <summary>
        /// Gets or sets the id proof name.
        /// </summary>
        public string? IdProofName { get; set; }

        /// <summary>
        /// Gets or sets the id proof name.
        /// </summary>
        public string? IdProofValue { get; set; }
        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the Blood Group value.
        /// </summary>
        public string? BloodGroup { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment type name.
        /// </summary>
        public string? AppointmentTypeName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? QueueEndDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? QueueStartDate { get; set; }

        /// <summary>
        /// Gets or sets the difference between queue start and queue end date.
        /// </summary>
        public double? Minutes { get; set; }

        /// <summary>
        ///  Gets or sets patient payment status.
        /// </summary>
        public bool? PatientPaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the patient reg amount.
        /// </summary>
        public decimal PatientRegistrationAmount { get; set; }

        /// <summary>
        /// Gets or sets the visitor name.
        /// </summary>
        public string VisitorName { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        ///  Gets or sets TransactionId.
        /// </summary>
        public string? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the is web.
        /// </summary>
        public bool IsWeb { get; set; }

        /// <summary>
        /// Gets or sets the is patient app.
        /// </summary>
        public bool IsPatientApp { get; set; }

        /// <summary>
        /// Gets or sets the is salucro.
        /// </summary>
        public bool IsSalucro { get; set; }
        /// <summary>
        /// Gets or sets the is encounter.
        /// </summary>
        public bool IsEncounter { get; set; }

        /// <summary>
        /// Gets or sets the name of the cubicle.
        /// </summary>
        /// <value>
        /// The name of the cubicle.
        /// </value>
        public string CubicleName { get; set; }

        /// <summary>
        /// Gets or sets the receiptCreatedByName.
        /// </summary>
        /// <value>
        /// The name of the cubicle.
        /// </value>
        public string ReceiptCreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the checked out.
        /// </summary>
        public DateTime? ReceiptDate { get; set; }


        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal AptRefundAmt { get; set; }

        /// <summary>
        /// Gets or sets the receipt id.
        /// </summary>
        public int? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the name of the cancelType.
        /// </summary>
        /// <value>
        /// The name of the cancel type for cancellation.
        /// </value>
        public string CancelType { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string? Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? SalucroTransactionId { get; set; }
        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        public string Message { get; set; }
        /// <summary>
        /// Gets or sets the count of message.
        /// </summary>
        public int MessageCount { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        public decimal? TotalAmount { get; set; }

        public decimal? Charges { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }
        /// <summary>
        /// Gets or sets referenceId.
        /// </summary>
        public int? ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? PatientSalutation { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? PatientRelation { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Area { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public DateTime? LastConsultedDate { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? LastConsultedDoctor { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public decimal? LastPaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? NextAppointment { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? HWCCategory { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public DateTime? FollowUpValidityDate { get; set; }

        /// <summary>
        /// Gets or sets the last appointment time.
        /// </summary>
        public string LastConsultedTime { get; set; }

        public string RelationName { get; set; }
        public string RealtiveEducation { get; set; }
        public string RelativeMobile { get; set; }
        public char RelativeGender { get; set; }
        public string Relation { get; set; }
        public string RelativeOccupation { get; set; }
        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? HowDidYouKnowId { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; }

        /// <summary>
        /// Gets or sets the web type.
        /// </summary>
        public string WebType { get; set; }


        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? AuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReasonId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string? Remarks { get; set; }

        public string? EncounterName { get; set; }

        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public List<PatientEmergencyModel>? EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public List<PatientInsuranceModel>? Insurances { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public List<PatientFamilyModel>? RelativeDetails { get; set; }
        ///// <summary>
        ///// Gets or sets the first name.
        ///// </summary>
        //public string FirstName { get; set; } = string.Empty;


        ///// <summary>
        ///// Gets or sets the middle name.
        ///// </summary>
        //public string? MiddleName { get; set; } = string.Empty;

        ///// <summary>
        ///// Gets or sets the last name.
        ///// </summary>
        //public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        ///// <summary>
        ///// Gets or sets the date of birth.
        ///// </summary>
        //public DateTime? DateOfBirth { get; set; }
        ///// <summary>
        ///// Gets or sets the age.
        ///// </summary>
        //public short? Age { get; set; }
        ///// <summary>
        ///// Gets or sets the gender.
        ///// </summary>
        //public char? Gender { get; set; }

        ///// <summary>
        ///// Gets or sets the marital status.
        ///// </summary>
        //public char? MaritalStatus { get; set; }
        ///// <summary>
        ///// Gets or sets the email.
        ///// </summary>
        //public string? Email { get; set; } = string.Empty;
        ///// <summary>
        ///// Gets or sets the mobile.
        ///// </summary>
        //public string? Mobile { get; set; } = string.Empty;
        ///// <summary>
        ///// Gets or sets the address line 2.
        ///// </summary>
        //public string? AddressLine2 { get; set; } = string.Empty;
        ///// <summary>
        ///// Gets or sets the Referred by name.
        ///// </summary>
        //public int? PatientReferredById { get; set; }
        ///// <summary>
        ///// Gets or sets the HWC patient identifier.
        ///// </summary>
        ///// <value>
        ///// The HWC patient identifier.
        ///// </value>
        //public int? HWCPatientId { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Education { get; set; }
        ///// <summary>
        ///// Gets or sets the Referred by name.
        ///// </summary>
        //public string? Occupation { get; set; }
        ///// <summary>
        ///// Gets or sets the Referred by name.
        ///// </summary>
        //public string? Nationality { get; set; }
        ///// <summary>
        ///// Gets or sets the Referred by name.
        ///// </summary>
        //public string? Religion { get; set; }
        ///// <summary>
        ///// Gets or sets the id proof id identifier.
        ///// </summary>
        ///// <value>
        ///// The id proof id identifier.
        ///// </value>
        //public int? IdProofId { get; set; }
        ///// <summary>
        ///// Gets or sets the id proof id identifier.
        ///// </summary>
        ///// <value>
        ///// The id proof id identifier.
        ///// </value>
        //public int? EducationId { get; set; }
        ///// <summary>
        ///// Gets or sets the id proof id identifier.
        ///// </summary>
        ///// <value>
        ///// The id proof id identifier.
        ///// </value>
        //public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? OccupationDetail { get; set; }

        /// <summary>
        /// Gets or sets the type of payment.
        /// </summary>
        public string? TypeOfPayment { get; set; }


        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public decimal AppointmentTotal { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal PatientTotal { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in rupees.
        /// </summary>
        public decimal AppointmentDiscountInRupees { get; set; }
    }
}
