﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System.Collections.Generic;

    /// <summary>
    /// The Video Call Push Notification.
    /// </summary>
    public class VideoCallPushNotificationModel
    {
        /// <summary>
        /// Gets or sets the device token.
        /// </summary>
        public string DeviceToken { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the device tokens.
        /// </summary>
        public List<string> DeviceTokens { get; set; } = new List<string>();

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string DeviceId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Doctor Email.
        /// </summary>
        public string DoctorEmail { get; set; } = string.Empty;

        /// <summary>
        ///  Gets or sets the message.
        /// </summary>
        public string Message { get; set; } = string.Empty;

        /// <summary>
        ///  Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; } = 0;

        /// <summary>
        ///  Gets or sets the telemedicine id.
        /// </summary>
        public int TelemedicineId { get; set; } = 0;
    }
}