﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The PatientLabBillModel.
    /// </summary>
    public class PatientLabBillModel
    {
        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int? NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double? Amount { get; set; }

        /// <summary>
        /// Gets or sets the bill identifier.
        /// </summary>
        /// <value>
        /// The bill identifier.
        /// </value>
        public int? HeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
    }
}
