﻿using System.ComponentModel.DataAnnotations;

namespace Hims.Shared.UserModels.Menu
{
    /// <summary> The chat.</summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the main page.
        /// </summary>
        /// <value>
        /// The main page.
        /// </value>
        public string MainPage { get; set; }

        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        [Required]
        public int MenuId { get; set; }

        /// <summary>
        /// Gets or sets the sub page.
        /// </summary>
        /// <value>
        /// The sub page.
        /// </value>
        public string SubPage { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        /// <value>
        /// The category.
        /// </value>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the URL.
        /// </summary>
        /// <value>
        /// The URL.
        /// </value>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the general classes.
        /// </summary>
        /// <value>
        /// The general classes.
        /// </value>
        public string GeneralClasses { get; set; }

        /// <summary>
        /// Gets or sets the icon classes.
        /// </summary>
        /// <value>
        /// The icon classes.
        /// </value>
        public string IconClasses { get; set; }

        /// <summary>
        /// Gets or sets the menu type identifier.
        /// </summary>
        /// <value>
        /// The menu type identifier.
        /// </value>
        public int? MenuTypeId { get; set; }
        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int? Priority { get; set; }
    }
}