﻿using System;

namespace Hims.Shared.UserModels.PediatricGraphs
{
    /// <summary>
    /// The pediatric chart authority model.
    /// </summary>
    public class PediatricChartAuthorityModel
    {
        /// <summary>
        /// Gets or sets the pediatric chart authority identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart authority identifier.
        /// </value>
        public int PediatricChartAuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the name of the authority.
        /// </summary>
        /// <value>
        /// The name of the authority.
        /// </value>
        public string AuthorityName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PediatricChartAuthorityModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }
    }
}
