﻿#nullable enable
namespace Hims.Shared.UserModels.ProviderScheduleVisits
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class InsertModel
    {

        /// <summary>
        /// Gets or sets the Provider Availability Visit Id
        /// </summary>
        public int ProviderAvailabilityVisitTypeId { get; set; }


        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public int? ProviderId { get; set; }
        public int? SpecializationId { get; set; }
        public int? LocationId { get; set; }
        public string ModifiedByName { get; set; }
        public string SchedulerTypeId { get; set; }

        public List<ProviderAvailabilityVisits> Visits { get; set; }
    }
    public class ProviderAvailabilityVisits
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int ProviderAvailabilityVisitTypeId { get; set; }

        public int? ProviderId { get; set; }
        public int? SpecializationId { get; set; }
        public int? LocationId { get; set; }

    }
}
