﻿namespace Hims.Shared.UserModels.Slots
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The Time Slot Model
    /// </summary>
    public class TimeSlotModel
    {
        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotValue { get; set; }

        /// <summary>
        /// Gets or sets the slot time.
        /// </summary>
        public TimeSpan SlotTime { get; set; }

        /// <summary>
        /// Gets or sets the slot name.
        /// </summary>
        public string SlotName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public SlotStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the charge.
        /// </summary>
        public decimal? Charge { get; set; }

        /// <summary>
        /// Gets or sets the duration
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets or sets the provider Availbaility id.
        /// </summary>
        public int? ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the session Id.
        /// </summary>
        public int? SessionId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability chargeType id
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string? Value { get; set; }

        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotValue24HoursEnd { get; set; }

        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotName12HoursEnd { get; set; }

        public string? AvailableDate { get; set; }

        public string? Id { get; set; }

        /// <summary>
        /// Gets or sets the slot type.
        /// </summary>
        public SlotType SlotType { get; set; }
        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public int? OTRoomAvailabilityId { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? RoomName { get; set; }
        /// <summary>
        /// Gets or sets the ot room id.
        /// </summary>
        public int? OTRoomId { get; set; }
        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        
    }

    /// <summary>
    /// The SlotStatus
    /// </summary>
    public enum SlotType
    {
        /// <summary>
        /// GeneralSLots is G.
        /// </summary>
        GeneralSLots = 'G',

        /// <summary>
        /// NewPatientSlots is N.
        /// </summary>
        NewPatientSlots = 'N',

        /// <summary>
        /// OfflinePatientSlots is O.
        /// </summary>
        OfflinePatientSlots = 'O',

        /// <summary>
        /// BreakSlots is B
        /// </summary>
        BreakSlots = 'B'
    }

    public class MultipleDays
    {
        public DateTime Date { get; set; }

        public List<TimeSlotModel> Slots { get; set; }

        public List<MultipleOTRooms> RoomSlots { get; set; }
        public string message { get; set; }
        public string? OtRoom { get; set; }
    }
    public class MultipleOTRooms
    {       
        public List<TimeSlotModel> Slots { get; set; }

        public string? OtRoom { get; set; }
    }

    public class SessionTimings
    {
        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime? Date { get; set; }

        /// <summary>
        /// Gets or sets the time.
        /// </summary>
        public string Time { get; set; }

        /// <summary>
        /// Gets or sets the slots.
        /// </summary>
        public List<TimeSlotModel> Slots { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        public string Message { get; set; }
    }
}