﻿namespace Hims.Domain.Entities.Labs
{
    using System;
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab sample collection.
    /// </summary>
    public class LabSampleCollection
    {
        /// <summary>
        /// Gets or sets the lab sample collection identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection identifier.
        /// </value>
        [Key, Identity]
        public int LabSampleCollectionId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the sample collected by.
        /// </summary>
        /// <value>
        /// The sample collected by.
        /// </value>
        public int? SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by.
        /// </summary>
        /// <value>
        /// The barcode generated by.
        /// </value>
        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the is barcode generated.
        /// </summary>
        /// <value>
        /// The is barcode generated.
        /// </value>
        public bool? IsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the collection date.
        /// </summary>
        /// <value>
        /// The collection date.
        /// </value>
        public DateTime? CollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the barcode date.
        /// </summary>
        /// <value>
        /// The barcode date.
        /// </value>
        public DateTime? BarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the consent form URL.
        /// </summary>
        /// <value>
        /// The consent form URL.
        /// </value>
        public string ConsentFormUrl { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        public DateTime? UploadedDate { get; set; }
    }
}
