﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The operation indent detail.
    /// </summary>
    public class OperationIndentDetail
    {
        /// <summary>
        /// Gets or sets the operation indent detail identifier.
        /// </summary>
        /// <value>
        /// The operation indent detail identifier.
        /// </value>
        [Key, Identity]
        public int OperationIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the operation indent header identifier.
        /// </summary>
        /// <value>
        /// The operation indent header identifier.
        /// </value>
        public int OperationIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }
    }
}
