﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Payment Initiation Log.
    /// </summary>
    public class PaymentInitiationLog
    {
        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        [Key, Identity]
        public int PaymentInitiationLogId { get; set; }

        /// <summary>
        /// Gets or sets the table data.
        /// </summary>
        public string TableData { get; set; }

        /// <summary>
        /// Gets or sets the table data.
        /// </summary>
        public string Mode { get; set; }

        /// <summary>
        /// Gets or sets the payment module id.
        /// </summary>
        public int PaymentModuleId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
    }
}
