﻿namespace Hims.Domain.Entities.Pharmacy
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy issued stock detail.
    /// </summary>
    public class PharmacyIssuedStockDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy issued stock detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock detail identifier.
        /// </value>
        [Key,Identity]
        public long PharmacyIssuedStockDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issued stock header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issued stock header identifier.
        /// </value>
        public long PharmacyIssuedStockHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy stock identifier.
        /// </value>
        public int PharmacyStockId { get; set; }
    }
}
