﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class ProgressReportMedication
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        [Key, Identity]
        public int ProgressReportMedicationId { get; set; }
        
        public int ProgressReportId { get; set; }
        public int PharmacyProductId { get; set; }
        public float Unit { get; set; }
        public int Duration { get; set; }
        public int MedicationDurationTypeId { get; set; }
        public bool Active { get; set; }
        public string Instructions { get; set; }
        
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        public DateTime? ModifiedDate { get; set; }
        public DateTime StartDate { get; set; }
        public DateTime EndDate { get; set; }
        public DateTime? StopDate { get; set; }

        public int? ModifiedBy { get; set; }
        public string StopReason { get; set; }
    }
}