﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The web telemedicine.
    /// </summary>
    public class TelemedicineCallHistory
    {
        /// <summary>
        /// Gets or sets the web telemedicine id.
        /// </summary>
        [Key, Identity]
        public int TelemedicineCallHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine history id.
        /// </summary>
        public int TelemedicineHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the status (1 = "Call Initiated", 2 = Call In Progress, 3 = "Call Complete", 4 = "Call Cancelled" ).
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// Gets or sets the status (1 = Video, 2 = Audio).
        /// </summary>
        public int CallType { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the in progress.
        /// </summary>
        /// <value>
        /// The in progress.
        /// </value>
        public bool? InProgress { get; set; }
    }
}