﻿namespace Hims.Domain.Entities.Vaccine
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The vaccine dependency.
    /// </summary>
    public class VaccineDependency
    {
        /// <summary>
        /// Gets or sets the vaccine dependency identifier.
        /// </summary>
        /// <value>
        /// The vaccine dependency identifier.
        /// </value>
        [Key, Identity]
        public int VaccineDependencyId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine master identifier.
        /// </summary>
        /// <value>
        /// The vaccine master identifier.
        /// </value>
        public int VaccineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the dependent on.
        /// </summary>
        /// <value>
        /// The dependent on.
        /// </value>
        public int DependentOn { get; set; }
    }
}
