﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Hims.Domain.Entities.Vendors
{
    /// <summary>
    /// The supplier product formulation.
    /// </summary>
     [Table("SupplierProductFormulation", Schema = "vendors")]
    public class SupplierProductFormulation
    {
        /// <summary>
        /// Gets or sets the supplier product formulation identifier.
        /// </summary>
        /// <value>
        /// The supplier product formulation identifier.
        /// </value>
        [Key,Identity]
        public int SupplierProductFormulationId { get; set; }

        /// <summary>
        /// Gets or sets the supplier product detail identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductDetailId{ get; set; }

        /// <summary>
        /// Gets or sets the operator.
        /// </summary>
        /// <value>
        /// The operator.
        /// </value>
        public string Operator { get; set; }

        /// <summary>
        /// Gets or sets the condition.
        /// </summary>
        /// <value>
        /// The condition.
        /// </value>
        public int Condition { get; set; }

        /// <summary>
        /// Gets or sets the foc quantity.
        /// </summary>
        /// <value>
        /// The foc quantity.
        /// </value>
        public int FOCQuantity { get; set; }
    }
}
