﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The visit type.
    /// </summary>
    public class VitalType
    {
        /// <summary>
        /// Gets or sets the vital type id.
        /// </summary>
        [Key, Identity]
        public int VitalTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the unit type.
        /// </summary>
        public string? UnitType { get; set; }

        /// <summary>
        /// Gets or sets the min.
        /// </summary>
        public float? Min { get; set; }

        /// <summary>
        /// Gets or sets the max.
        /// </summary>
        public float? Max { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }        
       
    }
}
