﻿namespace Hims.Domain.Services
{
    using Hims.Shared.Library.Helpers;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IGynEncounterService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<GynEncounterModel> FindAsync(int appointmentId, bool isAdmission);
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<GynEncounterModel> FindEncounterDataAsync(int appointmentId, bool isAdmission);
        
        /// <summary>
        /// The add internal medicine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAltAsync(GynEncounterModifyModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAltAsync(GynEncounterModifyModel model);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<GynEncounterResource> FindDashboardAsync(int appointmentId, GynEncounterType type, bool isAdmission);


        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<GynEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId,bool isAdmission);

        /// <summary>
        /// Gets the account based on appointment identifier.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<AppointmentModel> GetAccountBasedOnAppointmentId(long appointmentId, bool isAdmission);
        /// <summary>
        /// The add anc card.
        /// </summary>
        /// <param name="model">
        /// The anc model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddGYNCardAsync(GYNCardGenerationModel model, string locationId);
        /// <summary>
        /// The fetch anc card.
        /// </summary>
        /// <param name="patientId">
        /// The patient id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<GYNCardGenerationModel> FetchGynCardAsync(int patientId);
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<GynEncounterResource> FindGyn(int appointmentId, GynEncounterType type, bool isAdmission);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> FetchVisitNoAsync(int patientId);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> getApppointmentId(int appointmentId,bool admission);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> getAptId(int aptId);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> InsertCommonEncounter(CommonEncounterModel model);
        /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> UpdateCommonEncounter(CommonEncounterModel model);
        Task<GynEncounterResource> FetchCommonEncounter(OBEncounterType type, GynEncounterType  gynEncounterType, int appointmentId, bool isAdmission);
         Task<IEnumerable<Trial>> FetchCreatedDateNurseNoteReport(int AdmissionId);
        Task<List<Trial>> FetchNurseNoteReport(int AdmissionId);
         /// <summary>
        /// The modify status.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<int> ModifyGynEncounterStatus(int appointmentId);

    }
}
