﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Labs = Shared.UserModels.ProgressReport.Labs;
    using MedicationInfo = Shared.UserModels.ProgressReport.MedicationInfo;

    /// <summary> The ChatService interface.</summary>
    public interface IProgressReportLabService
    {
        /// <summary>
        /// Fetches the lab information asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MedicationInfo.LabFetchModel>> FetchLabInfoAsync(Labs.FilterModel model);

        /// <summary>
        /// Fetches the master medications asynchronous.
        /// </summary>
        /// <param name="term">The term.</param>
        /// <param name="locationId"></param>
        /// <returns></returns>
        Task<IEnumerable<Labs.MasterViewModel>> FetchMasterLabsAsync(string term, int locationId);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Labs.NewLabsViewModel>> FetchAsync(Labs.FilterModel model);
    }
}
