﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class DietItemsServices : IDietItemsService
    {

        // <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;


        /// <inheritdoc cref="IDietSlotsMasterService" />
        public DietItemsServices(IUnitOfWork unitOfWork
           )
        {
            this.unitOfWork = unitOfWork;
        }

        public async Task<IEnumerable<DietItemsModel>> FetchItemsAsync(DietItemsModel model)
        {
            var where = $@" where 1=1 ";
            if (model.Active == true)
            {
                where += $@" and di.""Active"" = true";
            }
            var query = $@"select di.""DietItemsId"",di.""DietItemsName"",di.""CreatedBy"",di.""CreatedDate"",di.""ModifiedBy"",di.""ModifiedDate"",
                        di.""MeasureId"",qm.""MeasureName"",a.""FullName"" as ""CreatedByName"", di.""Active"",b.""FullName"" as ""ModifiedByName""
                        from ""DietItems"" di
                        join ""QuantityMeasure"" qm on qm.""MeasureId""=di.""MeasureId""
                        join ""Account"" a on a.""AccountId"" = di.""CreatedBy""
                        left join  ""Account"" b on b.""AccountId"" = di.""ModifiedBy"" {where}";
            return await this.unitOfWork.Current.QueryAsync<DietItemsModel>(query);
        }

        public async Task<IEnumerable<DietItemsModel>> FetchMeasureAsync(DietItemsModel model)
        {
            var query = $@"select * from ""QuantityMeasure"" ";
            return await this.unitOfWork.Current.QueryAsync<DietItemsModel>(query);
        }

        public async Task<int> InsertItemsAsync(DietItemsModel model)
        {
            var isExists = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"SELECT ""DietItemsId"" from ""DietItems"" WHERE UPPER(TRIM(""DietItemsName"")) = UPPER(TRIM('{model.DietItemsName}'))");
            if (isExists > 0)
            {
                return -1;
            }
            var slot = new DietItems
            {
                DietItemsName = model.DietItemsName,
                Active = true,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
                MeasureId = model.MeasureId

            };

            return await this.unitOfWork.DietItems.InsertAsync(slot);
        }
        public async Task<int> UpdateAsync(DietItemsModel model)
        {

            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""DietItems"" where  lower (""DietItemsName"") = '{model.DietItemsName.ToLower()}' and ""DietItemsId"" <> {model.DietItemsId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.DietItems.FindAsync(m => m.DietItemsId == model.DietItemsId);
            if (record == null)
            {
                return -2;
            }
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.DietItemsName = model.DietItemsName;
            record.Active = model.Active;
            record.MeasureId = model.MeasureId;
            return await this.unitOfWork.DietItems.UpdateAsync(record);
        }
        public async Task<int> ModifyStatusAsync(DietItemsModel model)
        {
            var query = $@"UPDATE ""DietItems"" SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""DietItemsId""= {model.DietItemsId}";

            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

    }
}
