﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using Hims.Shared.Library;
using Hims.Shared.Library.Enums;
using Hims.Shared.Library.Helpers;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class IvfEncounterServices : IIvfEncounterServices
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;
        /// <summary>
        /// The time line services
        /// </summary>
        private readonly ITimelineService timelineService;

        /// <inheritdoc cref="IIvfEncounterService"/>
        public IvfEncounterServices(ITimelineService timelineService, IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
            this.timelineService = timelineService;
        }


        /// <inheritdoc />
        public async Task<CommonResponse> AddAsync(IvfEncounterModifyModel model)
        {
            try
            {
                var commonResponse = new CommonResponse();

                var checkIf = model.IsAdmission
                    ? await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""IvfEncounterId"") FROM ""IvfEncounter"" WHERE ""AdmissionId"" = {model.AppointmentId}")
                    : await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""IvfEncounterId"") FROM ""IvfEncounter"" WHERE ""AppointmentId"" = {model.AppointmentId}");
                if (checkIf > 0)
                {
                    commonResponse.Response = -1;
                    return commonResponse;
                }

                var encounter = new IvfEncounter
                {
                    Active = true,
                    AppointmentId = model.AppointmentId,
                    IvfEncounterDate = DateTime.Now,
                    CreatedBy = model.ModifiedBy,
                    CreatedDate = DateTime.Now
                };

                switch (model.Type)
                {
                    case IvfEncounterType.GynHistory:
                        encounter.GynHistory = model.JsonString;
                        break;
                    case IvfEncounterType.GynIUI:
                        encounter.GynIUI = model.JsonString;
                        break;
                    case IvfEncounterType.MensutralHistory:
                        encounter.MensutralHistory = model.JsonString;
                        break;
                    case IvfEncounterType.BirthControl:
                        encounter.BirthControl = model.JsonString;
                        break;
                    case IvfEncounterType.EmbryoFreezing:
                        encounter.EmbryoFreezing = model.JsonString;
                        break;
                    case IvfEncounterType.CoitalHistory:
                        encounter.CoitalHistory = model.JsonString;
                        break;
                    case IvfEncounterType.PreviousInfertilityTreatmentHistory:
                        encounter.PreviousInfertilityTreatmentHistory = model.JsonString;
                        break;
                    case IvfEncounterType.MedicalAndSurgicalHistory:
                        encounter.MedicalAndSurgicalHistory = model.JsonString;
                        break;
                    case IvfEncounterType.PreviousObstetricHistory:
                        encounter.PreviousObstetricHistory = model.JsonString;
                        break;
                    case IvfEncounterType.IvfData:
                        encounter.IvfData = model.JsonString;
                        break;
                    case IvfEncounterType.IvfSimulationScan:
                        encounter.IvfSimulationScan = model.JsonString;
                        break;
                    case IvfEncounterType.IvfSummary:
                        encounter.IvfSummary = model.JsonString;
                        break;
                    case IvfEncounterType.SingleTriggerInjection:
                        encounter.SingleTriggerInjection = model.JsonString;
                        break;
                    case IvfEncounterType.IvfDualTriggerInjection:
                        encounter.IvfDualTriggerInjection = model.JsonString;
                        break;
                    case IvfEncounterType.Fet:
                        encounter.Fet = model.JsonString;
                        break;

                    case IvfEncounterType.InfertilityHistory:
                        encounter.InfertilityHistory = model.JsonString;
                        break;
                    case IvfEncounterType.MarriedLifeHistory:
                        encounter.MarriedLifeHistory = model.JsonString;
                        break;
                    case IvfEncounterType.ContraceptionHistory:
                        encounter.ContraceptionHistory = model.JsonString;
                        break;
                    case IvfEncounterType.MenstrualHistoryPresent:
                        encounter.MenstrualHistoryPresent = model.JsonString;
                        break;
                    case IvfEncounterType.AddIUIData:
                        encounter.AddIUIData = model.JsonString;
                        break;
                    case IvfEncounterType.DualTriggerInjection:
                        encounter.DualTriggerInjection = model.JsonString;
                        break;
                    case IvfEncounterType.IUIStimulationScan:
                        encounter.IUIStimulationScan = model.JsonString;
                        break;
                    case IvfEncounterType.IUISummary:
                        encounter.IUISummary = model.JsonString;
                        break;
                    case IvfEncounterType.Laproscopy:
                        encounter.Laproscopy = model.JsonString;
                        break;
                    case IvfEncounterType.Hysteroscopy:
                        encounter.Hysteroscopy = model.JsonString;
                        break;
                    case IvfEncounterType.OtherInvestigationHistory:
                        encounter.OtherInvestigationHistory = model.JsonString;
                        break;
                    case IvfEncounterType.PersonalHistory:
                        encounter.PersonalHistory = model.JsonString;
                        break;
                    case IvfEncounterType.FamilyHistory:
                        encounter.FamilyHistory = model.JsonString;
                        break;
                    case IvfEncounterType.PhysicalGyecologicalHistory:
                        encounter.PhysicalGyecologicalHistory = model.JsonString;
                        break;
                    case IvfEncounterType.EmbryoThawing:
                        encounter.EmbryoThawing = model.JsonString;
                        break;
                    case IvfEncounterType.Aspiration:
                        encounter.Aspiration = model.JsonString;
                        break;
                    case IvfEncounterType.CryoPreservation:
                        encounter.CryoPreservation = model.JsonString;
                        break;
                    case IvfEncounterType.OocytCryoPreservation:
                        encounter.OocytCryoPreservation = model.JsonString;
                        break;
                    case IvfEncounterType.Fertilization:
                        encounter.Fertilization = model.JsonString;
                        break;
                    case IvfEncounterType.EmbryoQuality:
                        encounter.EmbryoQuality = model.JsonString;
                        break;
                    case IvfEncounterType.StimulationChart:
                        encounter.StimulationChart = model.JsonString;
                        break;
                    case IvfEncounterType.ObservationInfertility:
                        encounter.ObservationInfertility = model.JsonString;
                        break;
                    case IvfEncounterType.OrdersPrescription:
                        encounter.OrdersPrescription = model.JsonString;
                        break;
                        
                }

                var response = await this.unitOfWork.IvfEncounters.InsertAsync(encounter);
                commonResponse.Response = response;
                return commonResponse;
            }
            catch (Exception EX)
            {
                return null;
            }

        }
        /// <inheritdoc />
        public async Task<IvfEncounter> FindAsync(int appointmentId, bool isAdmission)
        {
            var query = isAdmission ?

                $@"SELECT A.""AppointmentId"", A.""PatientId"", ivf.""IvfEncounterId"", ""ContraceptionHistory"",""BirthControl"", ""GynHistory"",""GynIUI"", ""MensutralHistory"", ""EmbryoFreezing"",
                    ""CoitalHistory"",""PreviousObstetricHistory"",""PreviousInfertilityTreatmentHistory"",""MedicalAndSurgicalHistory"",""OtherInvestigationHistory"",""MenstrualHistoryPresent"",""SingleTriggerInjection"",""IvfSimulationScan"",""IvfData"",
                            ""PersonalHistory"",""FamilyHistory"",""PhysicalGyecologicalHistory"",""InfertilityHistory"", ""EmbryoThawing"",""Aspiration"",""CryoPreservation"", ""ContraceptionHistory"",""IUIStimulationScan"", ""AddIUIData"",""IvfDualTriggerInjection"",
                          ""OocytCryoPreservation"",""EmbyologyDetail"",""IvfSummary"",""Fertilization"",""EmbryoQuality"",""StimulationChart"",""IUISummary"",""Laproscopy"",""Hysteroscopy"",""MarriedLifeHistory"",""DualTriggerInjection"",""ObservationInfertility"",""Fet""
                            FROM ""Appointment"" A
                            LEFT JOIN ""IvfEncounter"" ivf ON ivf.""AdmissionId"" = A.""AdmissionId""
                            where A.""AdmissionId"" = '{appointmentId}' AND A.""Active"" IS TRUE" :
                $@"SELECT A.""AppointmentId"", A.""PatientId"", ivf.""IvfEncounterId"", ""BirthControl"", ""GynHistory"",""GynIUI"", ""MensutralHistory"", ""EmbryoFreezing"",""SingleTriggerInjection"",""IvfData"",
                    ""CoitalHistory"",""PreviousObstetricHistory"",""PreviousInfertilityTreatmentHistory"",""MedicalAndSurgicalHistory"",""OtherInvestigationHistory"",""AddIUIData"",""MenstrualHistoryPresent"",""IUIStimulationScan"",""IvfSimulationScan"",
                            ""PersonalHistory"",""FamilyHistory"",""PhysicalGyecologicalHistory"",""InfertilityHistory"", ""EmbryoThawing"",""Aspiration"",""CryoPreservation"",""OocytCryoPreservation"",""EmbyologyDetail"",""IvfSummary"",""Fertilization"",
            ""EmbryoQuality"",""StimulationChart"",""IUISummary"",""Laproscopy"",""Hysteroscopy"",""MarriedLifeHistory"",""DualTriggerInjection"",""ObservationInfertility"", ""ContraceptionHistory"",""Fet"",""IvfDualTriggerInjection""
                            FROM ""Appointment"" A
                              LEFT JOIN ""IvfEncounter"" ivf ON ivf.""AppointmentId"" = A.""AppointmentId""
                            where A.""AppointmentId"" = '{appointmentId}' AND A.""Active"" IS TRUE";

            return this.unitOfWork.Current.QueryFirstOrDefault<IvfEncounter>(query);



        }

        public async Task<IvfEncounterResource> FindDashboardAsync(int appointmentId, IvfEncounterType type, bool isAdmission)
        {
            try
            {
                var ivfEncounter = isAdmission
                        ? await this.unitOfWork.IvfEncounters.FindAsync(m => m.AdmissionId == appointmentId)
                        : await this.unitOfWork.IvfEncounters.FindAsync(m => m.AppointmentId == appointmentId);

                var ivfEncouterResources = new IvfEncounterResource
                {
                    AppointmentId = appointmentId,
                    IvfEncounterId = null,
                    JsonString = null
                };

                if (ivfEncounter != null)
                {
                    ivfEncouterResources.IvfEncounterId = ivfEncounter.IvfEncounterId;
                    switch (type)
                    {

                        case IvfEncounterType.GynHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.GynHistory;
                            break;
                        case IvfEncounterType.GynIUI:
                            ivfEncouterResources.JsonString = ivfEncounter.GynIUI;
                            break;
                        case IvfEncounterType.MensutralHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.MensutralHistory;
                            break;
                        case IvfEncounterType.BirthControl:
                            ivfEncouterResources.JsonString = ivfEncounter.BirthControl;
                            break;
                        case IvfEncounterType.EmbryoFreezing:
                            ivfEncouterResources.JsonString = ivfEncounter.EmbryoFreezing;
                            break;
                        case IvfEncounterType.InfertilityHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.InfertilityHistory;
                            break;
                        case IvfEncounterType.MarriedLifeHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.MarriedLifeHistory;
                            break;
                        case IvfEncounterType.ContraceptionHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.ContraceptionHistory;
                            break;
                        case IvfEncounterType.MenstrualHistoryPresent:
                            ivfEncouterResources.JsonString = ivfEncounter.MenstrualHistoryPresent;
                            break;
                        case IvfEncounterType.OtherInvestigationHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.OtherInvestigationHistory;
                            break;
                        case IvfEncounterType.PersonalHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.PersonalHistory;
                            break;
                        case IvfEncounterType.FamilyHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.FamilyHistory;
                            break;
                        case IvfEncounterType.PhysicalGyecologicalHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.PhysicalGyecologicalHistory;
                            break;
                        case IvfEncounterType.CoitalHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.CoitalHistory;
                            break;
                        case IvfEncounterType.PreviousInfertilityTreatmentHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.PreviousInfertilityTreatmentHistory;
                            break;
                        case IvfEncounterType.PreviousObstetricHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.PreviousObstetricHistory;
                            break;
                        case IvfEncounterType.MedicalAndSurgicalHistory:
                            ivfEncouterResources.JsonString = ivfEncounter.MedicalAndSurgicalHistory;
                            break;
                        case IvfEncounterType.Aspiration:
                            ivfEncouterResources.JsonString = ivfEncounter.Aspiration;
                            break;
                        case IvfEncounterType.CryoPreservation:
                            ivfEncouterResources.JsonString = ivfEncounter.CryoPreservation;
                            break;
                        case IvfEncounterType.OocytCryoPreservation:
                            ivfEncouterResources.JsonString = ivfEncounter.OocytCryoPreservation;
                            break;
                        case IvfEncounterType.EmbryoThawing:
                            ivfEncouterResources.JsonString = ivfEncounter.EmbryoThawing;
                            break;
                        case IvfEncounterType.EmbyologyDetail:
                            ivfEncouterResources.JsonString = ivfEncounter.EmbyologyDetail;
                            break;
                        case IvfEncounterType.IvfData:
                            ivfEncouterResources.JsonString = ivfEncounter.IvfData;
                            break;
                        case IvfEncounterType.IvfSimulationScan:
                            ivfEncouterResources.JsonString = ivfEncounter.IvfSimulationScan;
                            break;
                        case IvfEncounterType.SingleTriggerInjection:
                            ivfEncouterResources.JsonString = ivfEncounter.SingleTriggerInjection;
                            break;
                        case IvfEncounterType.IvfDualTriggerInjection:
                            ivfEncouterResources.JsonString = ivfEncounter.IvfDualTriggerInjection;
                            break;
                        case IvfEncounterType.Fet:
                            ivfEncouterResources.JsonString = ivfEncounter.Fet;
                            break;
                        case IvfEncounterType.IvfSummary:
                            ivfEncouterResources.JsonString = ivfEncounter.IvfSummary;
                            break;
                        case IvfEncounterType.ObservationInfertility:
                            ivfEncouterResources.JsonString = ivfEncounter.ObservationInfertility;
                            break;
                        case IvfEncounterType.Fertilization:
                            ivfEncouterResources.JsonString = ivfEncounter.Fertilization;
                            break;
                        case IvfEncounterType.EmbryoQuality:
                            ivfEncouterResources.JsonString = ivfEncounter.EmbryoQuality;
                            break;
                        case IvfEncounterType.StimulationChart:
                            ivfEncouterResources.JsonString = ivfEncounter.StimulationChart;
                            break;
                        case IvfEncounterType.Laproscopy:
                            ivfEncouterResources.JsonString = ivfEncounter.Laproscopy;
                            break;
                        case IvfEncounterType.Hysteroscopy:
                            ivfEncouterResources.JsonString = ivfEncounter.Hysteroscopy;
                            break;
                        case IvfEncounterType.DualTriggerInjection:
                            ivfEncouterResources.JsonString = ivfEncounter.DualTriggerInjection;
                            break;
                        case IvfEncounterType.IUISummary:
                            ivfEncouterResources.JsonString = ivfEncounter.IUISummary;
                            break;
                        case IvfEncounterType.IUIStimulationScan:
                            ivfEncouterResources.JsonString = ivfEncounter.IUIStimulationScan;
                            break;
                        case IvfEncounterType.AddIUIData:
                            ivfEncouterResources.JsonString = ivfEncounter.AddIUIData;
                            break;
                        case IvfEncounterType.OrdersPrescription:
                            ivfEncouterResources.JsonString = ivfEncounter.OrdersPrescription;
                            break;
                    }
                }

                return ivfEncouterResources;
            }
            catch(Exception e)
            {
                return null;
            }
        }

        public async Task<IvfEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId)
        {
            var query = $@"SELECT Ap.""AppointmentId"", Ap.""AppointmentNo"", Ap.""AppointmentDate"", Ap.""AppointmentTime"", 
                             (case when Ap.""PatientFamilyId"" is not null then PF.""FullName"" else P.""FullName"" end) AS ""PatientName"", 
                             (case when Ap.""PatientFamilyId"" is not null then PF.""Gender"" else P.""Gender"" end) AS ""PatientGender"",C.""CountryCode"" AS ""PatientCountryCode"",
                             CONCAT(Pr.""Salutation"",' ', Pr.""FullName"") AS ""ProviderName"",P.""Mobile"" AS ""PatientMobile"",
                            (case when Ap.""PatientFamilyId"" is not null then PF.""Age"" else P.""Age"" end) AS ""PatientAge"", P.""DateOfBirth"" AS ""PatientDateOfBirth"", ivf.""IvfEncounterId"",
                            ""BirthControl"", ""GynHistory"",""GynIUI"", ""MensutralHistory"", ""EmbryoFreezing"", ""ContraceptionHistory"", ""MenstrualHistoryPresent"", ""IvfData"",
                             ""CoitalHistory"",""PreviousObstetricHistory"",""PreviousInfertilityTreatmentHistory"",""MedicalAndSurgicalHistory"",""OtherInvestigationHistory"",""AddIUIData"",""IvfDualTriggerInjection"",""Fet"",""SingleTriggerInjection"",""IvfSimulationScan"",
                            ""PersonalHistory"",""FamilyHistory"",""PhysicalGyecologicalHistory"",""InfertilityHistory"", ""EmbryoThawing"",""Aspiration"",""CryoPreservation"",""OocytCryoPreservation"",""EmbyologyDetail"",""IvfSummary"",""Fertilization"",""EmbryoQuality"",""StimulationChart"",""IUISummary"",""Laproscopy"",""Hysteroscopy"",
""MarriedLifeHistory"",""DualTriggerInjection"",""ObservationInfertility"",""OrdersPrescription""
				            FROM ""Appointment"" Ap
							LEFT JOIN ""IvfEncounter"" ivf ON ivf.""AppointmentId""= Ap.""AppointmentId""
                            LEFT JOIN ""Provider"" pr on pr.""ProviderId""=Ap.""ProviderId""
							JOIN ""Patient"" P ON P.""PatientId"" = Ap.""PatientId""
                            Left join ""PatientFamily"" PF on PF.""PatientFamilyId"" = Ap.""PatientFamilyId""
                            LEFT JOIN ""Country"" C ON C.""CountryId""=P.""CountryId""
                            where Ap.""AppointmentId"" = {appointmentId} AND Ap.""Active"" IS TRUE";
            return await this.unitOfWork.Current.QueryFirstOrDefaultAsync<IvfEncounterFullTranscriptModel>(query);
        }

        public async Task<CommonResponse> UpdateAsync(IvfEncounterModifyModel model)
        {
            var commonResponse = new CommonResponse();

            var encounter = await this.unitOfWork.IvfEncounters.FindAsync(m => m.IvfEncounterId == model.IvfEncounterId);

            var checkIf = model.IsAdmission
                ? await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"select count((""IvfEncounterId"")) from ""IvfEncounter"" where ""AdmissionId""='{model.AppointmentId}' AND ""IvfEncounterId"" <> '{model.IvfEncounterId}'")
                : await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"select count((""IvfEncounterId"")) from ""IvfEncounter"" where ""AppointmentId""='{model.AppointmentId}' AND ""IvfEncounterId"" <> '{model.IvfEncounterId}'");
            if (checkIf > 0)
            {
                commonResponse.Response = -1;
                return commonResponse;
            }

            encounter.ModifiedBy = model.ModifiedBy;
            encounter.ModifiedDate = DateTime.Now;



            switch (model.Type)
            {
                case IvfEncounterType.GynHistory:
                    encounter.GynHistory = model.JsonString;
                    break;
                case IvfEncounterType.GynIUI:
                    encounter.GynIUI = model.JsonString;
                    break;
                case IvfEncounterType.MensutralHistory:
                    encounter.MensutralHistory = model.JsonString;
                    break;
                case IvfEncounterType.BirthControl:
                    encounter.BirthControl = model.JsonString;
                    break;
                case IvfEncounterType.EmbryoFreezing:
                    encounter.EmbryoFreezing = model.JsonString;
                    break;
                case IvfEncounterType.InfertilityHistory:
                    encounter.InfertilityHistory = model.JsonString;
                    break;
                case IvfEncounterType.MarriedLifeHistory:
                    encounter.MarriedLifeHistory = model.JsonString;
                    break;
                case IvfEncounterType.ContraceptionHistory:
                    encounter.ContraceptionHistory = model.JsonString;
                    break;
                case IvfEncounterType.MenstrualHistoryPresent:
                    encounter.MenstrualHistoryPresent = model.JsonString;
                    break;
                case IvfEncounterType.AddIUIData:
                    encounter.AddIUIData = model.JsonString;
                    break;
                case IvfEncounterType.DualTriggerInjection:
                    encounter.DualTriggerInjection = model.JsonString;
                    break;
                case IvfEncounterType.IUIStimulationScan:
                    encounter.IUIStimulationScan = model.JsonString;
                    break;
                case IvfEncounterType.IUISummary:
                    encounter.IUISummary = model.JsonString;
                    break;
                case IvfEncounterType.Laproscopy:
                    encounter.Laproscopy = model.JsonString;
                    break;
                case IvfEncounterType.Hysteroscopy:
                    encounter.Hysteroscopy = model.JsonString;
                    break;
                case IvfEncounterType.OtherInvestigationHistory:
                    encounter.OtherInvestigationHistory = model.JsonString;
                    break;
                case IvfEncounterType.PersonalHistory:
                    encounter.PersonalHistory = model.JsonString;
                    break;
                case IvfEncounterType.FamilyHistory:
                    encounter.FamilyHistory = model.JsonString;
                    break;
                case IvfEncounterType.PhysicalGyecologicalHistory:
                    encounter.PhysicalGyecologicalHistory = model.JsonString;
                    break;
                case IvfEncounterType.CoitalHistory:
                    encounter.CoitalHistory = model.JsonString;
                    break;
                case IvfEncounterType.PreviousInfertilityTreatmentHistory:
                    encounter.PreviousInfertilityTreatmentHistory = model.JsonString;
                    break;
                case IvfEncounterType.MedicalAndSurgicalHistory:
                    encounter.MedicalAndSurgicalHistory = model.JsonString;
                    break;
                case IvfEncounterType.PreviousObstetricHistory:
                    encounter.PreviousObstetricHistory = model.JsonString;
                    break;
                case IvfEncounterType.EmbryoThawing:
                    encounter.EmbryoThawing = model.JsonString;
                    break;
                case IvfEncounterType.Aspiration:
                    encounter.Aspiration = model.JsonString;
                    break;
                case IvfEncounterType.CryoPreservation:
                    encounter.CryoPreservation = model.JsonString;
                    break;
                case IvfEncounterType.OocytCryoPreservation:
                    encounter.OocytCryoPreservation = model.JsonString;
                    break;
                case IvfEncounterType.EmbyologyDetail:
                    encounter.EmbyologyDetail = model.JsonString;
                    break;
                case IvfEncounterType.IvfData:
                    encounter.IvfData = model.JsonString;
                    break;
                case IvfEncounterType.IvfSimulationScan:
                    encounter.IvfSimulationScan = model.JsonString;
                    break;
                case IvfEncounterType.SingleTriggerInjection:
                    encounter.SingleTriggerInjection = model.JsonString;
                    break;
                case IvfEncounterType.IvfDualTriggerInjection:
                    encounter.IvfDualTriggerInjection = model.JsonString;
                    break;
                case IvfEncounterType.Fet:
                    encounter.Fet = model.JsonString;
                    break;
                case IvfEncounterType.Fertilization:
                    encounter.Fertilization = model.JsonString;
                    break;
                case IvfEncounterType.EmbryoQuality:
                    encounter.EmbryoQuality = model.JsonString;
                    break;
                case IvfEncounterType.StimulationChart:
                    encounter.StimulationChart = model.JsonString;
                    break;
              
                case IvfEncounterType.ObservationInfertility:
                    encounter.ObservationInfertility = model.JsonString;
                    break;
                case IvfEncounterType.IvfSummary:
                    encounter.IvfSummary = model.JsonString;
                    break;
                case IvfEncounterType.OrdersPrescription:
                    encounter.OrdersPrescription = model.JsonString;
                    break;
                    
            }
        


            var response = await this.unitOfWork.IvfEncounters.UpdateAsync(encounter);
            commonResponse.Response = response > 0 ? encounter.IvfEncounterId : 0;
            return commonResponse;

        }

    }
}

