﻿using System;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.Filters;
using System;
using Hims.Domain.Entities;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Collections.Generic;
using System.Text;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.Library.Helpers;
using Newtonsoft.Json;
using Hims.Shared.UserModels.OBEncounter;
using Hims.Shared.UserModels.PediatricEncounter;

namespace Hims.Infrastructure.Services
{
    public class PhysiotherapyEncounterService : IPhysiotherapyEncounterService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IWardService" />
        public PhysiotherapyEncounterService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;




      
        public async Task<int> AddPhysiotherapyEncounter(PhysiotherapyEncounterModel model)
        {
                PhysiotherapyEncounter physiotherapy = new PhysiotherapyEncounter
                {
                    AppointmentId = (int)model.AppointmentId,
                    CreatedBy =(int)model.CreatedBy,
                    CreatedDate = DateTime.Now,
                };
                switch (model.Type)
                {
                    case PhysiotherapyEncounterType.SpecialFeature:
                        physiotherapy.SpecialFeature = model.JsonString;
                        break;
                }

                var response = await this.unitOfWork.PhysiotherapyEncounters.InsertAsync(physiotherapy);
                return response;
            
        }

       public async Task<PhysiotherapyEncounterModel> GetAllPhysiotherapyEncounter(PhysiotherapyEncounterModel model)
        {
        
            string where = "where 1=1 ";

            if (model.AppointmentId > 0)
            {
                where += $@" and PE.""AppointmentId"" = {model.AppointmentId}";
            }

            if (model.Active != null)
            {
                where += $@" and PE.""Active"" = {model.Active}";
            }
            var Query = $@"	  select  PE.""PhysiotherapyEncounterId"",PE.""AppointmentId"",PE.""Active"",A.""FullName"" as ""CreatedByName"",
			   PE.""CreatedDate"", B.""FullName"" as ""ModifiedByName"",PE.""CreatedBy"",PE.""ModifiedBy"" , PE.""ModifiedDate"",PE.""SpecialFeature""
			   from  ""PhysiotherapyEncounter"" PE
			   join ""Account"" A  on A.""AccountId"" = PE.""CreatedBy""
			   left join ""Account"" B on B.""AccountId"" = PE.""ModifiedBy"" {where}";

          
            var data = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<PhysiotherapyEncounterModel>(Query);

            var physiotherapyEncounterModel = new PhysiotherapyEncounterModel
            {
                AppointmentId = model.AppointmentId,
                PhysiotherapyEncounterId = null,
                JsonString = null
            };

            if (data != null && model.Type != null)
            {

                    physiotherapyEncounterModel.PhysiotherapyEncounterId = data.PhysiotherapyEncounterId;
                    switch (model.Type)
                    {
                        case PhysiotherapyEncounterType.SpecialFeature:
                            physiotherapyEncounterModel.JsonString = data.SpecialFeature;
                            break;
                    }

                    return physiotherapyEncounterModel;
            }

            return data;
            
        }

       public async Task<int> UpdatePhysiotherapyEncounter(PhysiotherapyEncounterModel model)
        {
            var PhysiotherapyEncounter = this.unitOfWork.PhysiotherapyEncounters.Find(s => s.AppointmentId == model.AppointmentId);
            if (PhysiotherapyEncounter == null)
            {
                return -2;
            }
            PhysiotherapyEncounter.ModifiedBy = model.ModifiedBy;
            PhysiotherapyEncounter.ModifiedDate = DateTime.Now;
            switch (model.Type)
            {
                case PhysiotherapyEncounterType.SpecialFeature:
                    PhysiotherapyEncounter.SpecialFeature = model.JsonString;
                    break;
            }

            var result = await this.unitOfWork.PhysiotherapyEncounters.UpdateAsync(PhysiotherapyEncounter);
            return result;

        }
    }
}
