﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.Filters;

    /// <inheritdoc />
    public class RadiologyService : IRadiologyService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <summary>Initializes a new instance of the <see cref="RadiologyService"/> class. Initializes a new instance of the <see cref="RadiologyService"/> class.</summary>
        /// <param name="unitOfWork">The unit of work.</param>
        public RadiologyService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<RadiologyModel>> FetchAsync(RadiologyFilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" AND ""Name"" ILIKE '%{model.Name}%'";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", ""RadiologyId"", ""Name"", ""Type"",
            ""CreatedDate"", ""CreatedBy"" FROM ""Radiology"" {where} Order by ""RadiologyId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<RadiologyModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<RadiologyModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> AddAsync(RadiologyModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""RadiologyId"") FROM ""Radiology"" WHERE ""Name"" = '{model.Name.Trim()}' AND ""RadiologyId"" <> {model.RadiologyId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var radiology = new Radiology
                               {
                                   Name = model.Name,
                                   Type = model.Type,
                                   CreatedBy = model.CreatedBy,
                                   CreatedDate = DateTime.UtcNow
                               };

            return await this.unitOfWork.Radiology.InsertAsync(radiology);
        }

        /// <inheritdoc />
        public async Task<int> UpdateAsync(RadiologyModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""RadiologyId"") FROM ""Radiology"" WHERE ""Name"" = '{model.Name.Trim()}' AND ""RadiologyId"" <> {model.RadiologyId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var radiology = await this.unitOfWork.Radiology.FindAsync(m => m.RadiologyId == model.RadiologyId);
            radiology.RadiologyId = model.RadiologyId;
            radiology.Type = model.Type?.Trim();
            radiology.Name = model.Name?.Trim();
            radiology.ModifiedBy = model.ModifiedBy;
            radiology.ModifiedDate = DateTime.UtcNow;

            return await this.unitOfWork.Radiology.UpdateAsync(radiology);
        }

        /// <inheritdoc />
        public Task<int> DeleteAsync(int radiologyId)
        {
            var query = $@"DELETE FROM ""Radiology"" WHERE ""RadiologyId""= {radiologyId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }
    }
}