﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The homeopathy full transcript model.
    /// </summary>
    public class HomeopathyFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }
        
        /// <summary>
        /// Gets or sets the homeopathy id.
        /// </summary>
        public long? HomeopathyId { get; set; }

        /// <summary>
        /// Gets or sets the confidential.
        /// </summary>
        public string? Confidential { get; set; }

        /// <summary>
        /// Gets or sets the cc and oc.
        /// </summary>
        public string? CCAndOC { get; set; }

        /// <summary>
        /// Gets or sets the additional complaints.
        /// </summary>
        public string? AdditionalComplaints { get; set; }

        /// <summary>
        /// Gets or sets the past illness.
        /// </summary>
        public string? PastIllness { get; set; }

        /// <summary>
        /// Gets or sets the family illness.
        /// </summary>
        public string? FamilyIllness { get; set; }

        /// <summary>
        /// Gets or sets the spouse and children.
        /// </summary>
        public string? SpouseAndChildren { get; set; }

        /// <summary>
        /// Gets or sets the personal history.
        /// </summary>
        public string? PersonalHistory { get; set; }

        /// <summary>
        /// Gets or sets the personal habits.
        /// </summary>
        public string? PersonalHabits { get; set; }

        /// <summary>
        /// Gets or sets the appetite and thirst.
        /// </summary>
        public string? AppetiteAndThirst { get; set; }

        /// <summary>
        /// Gets or sets the bowel movements.
        /// </summary>
        public string? BowelMovements { get; set; }

        /// <summary>
        /// Gets or sets the urination.
        /// </summary>
        public string? Urination { get; set; }

        /// <summary>
        /// Gets or sets the sweat fever chill.
        /// </summary>
        public string? SweatFeverChill { get; set; }

        /// <summary>
        /// Gets or sets the chest heart cold cough.
        /// </summary>
        public string? ChestHeartColdCough { get; set; }

        /// <summary>
        /// Gets or sets the sexual sphere.
        /// </summary>
        public string? SexualSphere { get; set; }

        /// <summary>
        /// Gets or sets the general complaints.
        /// </summary>
        public string? GeneralComplaints { get; set; }

        /// <summary>
        /// Gets or sets the affected factors.
        /// </summary>
        public string? AffectedFactors { get; set; }

        /// <summary>
        /// Gets or sets the emotional nature.
        /// </summary>
        public string? EmotionalNature { get; set; }

        /// <summary>
        /// Gets or sets the sleep and dreams.
        /// </summary>
        public string? SleepAndDreams { get; set; }

        /// <summary>
        /// Gets or sets the children.
        /// </summary>
        public string? Children { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }
    }
}
