﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The Machine Model
    /// </summary>
    public class MachineModel
    {
        /// <summary>
        /// Gets or sets the machine id.
        /// </summary>
        public int MachineId { get; set; }
        /// <summary>
        /// Gets or sets the machine code.
        /// </summary>
        public string MachineCode { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

      
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The count of total items.
        /// </value>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the page size
        /// </summary>
        /// <value>
        /// The size of the page
        /// </value>
        public int? PageSize { get; set; }
        /// <summary>
        /// Gets or sets the page Index
        /// </summary>
        /// <value>
        /// The index of the page
        /// </value>
        public int? PageIndex { get; set; }
        /// <summary>
        /// Gets or sets the login by role
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public short? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        /// <value>
        /// The created by name.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }


    }
}
