﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The role.
    /// </summary>
    public class PayCategoryModel
    {
        /// <summary>
        /// Gets or sets the pay category id.
        /// </summary>
        public int? PayCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the pay category  name.
        /// </summary>
        public string PayCategoryName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        /// <value>
        /// The login role id.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets TotalItems.
        /// </summary>
        public int? TotalItems { get; set; }
    }
}
