﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The provider encounter.
    /// </summary>
    public class ProviderEncounterModel
    {
        /// <summary>
        /// Gets or sets the provider general advice id.
        /// </summary>
        public int ProviderGeneralAdviceId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the general advice ids.
        /// </summary>
        public string? GeneralAdviceIds { get; set; }

        /// <summary>
        /// Gets or sets the icd ids.
        /// </summary>
        public string? IcdIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for allergies.
        /// </summary>
        public string? AllergyIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for reactions.
        /// </summary>
        public string? ReactionIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for hospitalization.
        /// </summary>
        public string? HospitalizationIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for pcare.
        /// </summary>
        public string? PCareIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for initial.
        /// </summary>
        public string? InitialIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for site.
        /// </summary>
        public string? SiteIds { get; set; }

        /// <summary>
        /// Gets or sets the look up value ids for vaccine.
        /// </summary>
        public string? VaccineIds { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab order value ids.
        /// </summary>
        public string? LabOrderValueIds { get; set; }

        /// <summary>
        /// Gets or sets the radiology value ids.
        /// </summary>
        public string? RadiologyValueIds { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
    }
}
