﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The Specialization.
    /// </summary>
    public class SpecializationModel
    {
        /// <summary>
        /// Gets or sets the Specialization id.
        /// </summary>
        public int SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>        
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the SpecializationIcon id.
        /// </summary>
        public int? SpecializationIconId { get; set; }

        /// <summary>
        /// Gets or sets the Specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the specialization description.
        /// </summary>
        public string SpecializationDescription { get; set; }

        /// <summary>
        /// Gets or sets the Encrypted Specialization Id.
        /// </summary>
        public string EncryptedSpecializationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the url.
        /// </summary>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the Icon name.
        /// </summary>
        public string? IconName { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets the LocationIds.
        /// </summary>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }

        /// <summary>
        /// Gets or sets the encounter type id.
        /// </summary>
        public int? EncounterTypeId { get; set; }

        /// <summary>
        /// Gets or sets the encounter name.
        /// </summary>
        public string? EncounterName { get; set; }

        /// <summary>
        /// Gets or sets the consultation type identifier.
        /// </summary>
        /// <value>
        /// The consultation type identifier.
        /// </value>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the consultation type.
        /// </summary>
        /// <value>
        /// The name of the consultation type.
        /// </value>
        public string ConsultationTypeName { get; set; }
        /// </summary>
        /// <value>
        /// The name of the created by  name.
        /// </value>
        public string CreatedByName { get; set; }
        /// </summary>
        /// <value>
        /// The name of the modified by  name.
        /// </value>
        public string ModifiedByName { get; set; }
    }
}
