﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The ticket details model.
    /// </summary>
    public class TicketDetailsModel
    {
        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the ticket timeline id.
        /// </summary>
        public long TicketTimelineId { get; set; }

        /// <summary>
        /// Gets or sets the ticket number.
        /// </summary>
        public string? TicketNumber { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string? Priority { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string? IssueWith { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the instruction.
        /// </summary>
        public string? Instruction { get; set; }

        /// <summary>
        /// Gets or sets the attachment.
        /// </summary>
        public string? Attachment { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the raised by name.
        /// </summary>
        public string? RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the support conversation.
        /// </summary>
        public string? SupportConversation { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string? Comments { get; set; }

        /// <summary>
        /// Gets or sets the conversation.
        /// </summary>
        public string? Conversation { get; set; }

        /// <summary>
        /// Gets or sets the assignee description.
        /// </summary>
        public string? AssigneeDescription { get; set; }

        /// <summary>
        /// Gets or sets the assignee name.
        /// </summary>
        public string? AssigneeName { get; set; }

        /// <summary>
        /// Gets or sets the assignee thumbnail url.
        /// </summary>
        public string? AssigneeThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the assignee status.
        /// </summary>
        public string? AssigneeStatus { get; set; }

        /// <summary>
        /// Gets or sets the support category id.
        /// </summary>
        public int SupportCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the raised by.
        /// </summary>
        public int RaisedBy { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the ticket owner id.
        /// </summary>
        public int? TicketOwnerId { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the assigned by id.
        /// </summary>
        public int AssignedById { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the assigned date.
        /// </summary>
        public DateTime? AssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the assignee start date.
        /// </summary>
        public DateTime? AssigneeStartDate { get; set; }

        /// <summary>
        /// Gets or sets the assignee end date.
        /// </summary>
        public DateTime? AssigneeEndDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public DateTime? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the due time.
        /// </summary>
        public string? DueTime { get; set; }

        /// <summary>
        /// Gets or sets the due date time.
        /// </summary>
        public string? DueDateTime { get; set; }

        /// <summary>
        /// Gets or sets the ticket owner.
        /// </summary>
        public string? TicketOwner { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the raised by role.
        /// </summary>
        public string? RaisedByRole { get; set; }

        /// <summary>
        /// Gets or sets the assignee account id.
        /// </summary>
        public int? AssigneeAccountId { get; set; }

        /// <summary>
        /// Gets or sets the new assignee name.
        /// </summary>
        public string? NewAssigneeName { get; set; }
    }
}
