﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The ticket timeline model.
    /// </summary>
    public class TicketTimelineModel
    {
        /// <summary>
        /// Gets or sets the ticket timeline id.
        /// </summary>
        public long TicketTimelineId { get; set; }

        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the assigned date.
        /// </summary>
        public DateTime AssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the assigned to name.
        /// </summary>
        public string? AssignedToName { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string? Priority { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string? Comments { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public int? AssignedTouser { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string? AssignedToUserName { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public bool? IsAssigneeUserUpdate { get; set; }
    }
}
