﻿namespace Hims.Shared.Library.MailKit
{
    using System.Collections.Generic;

    /// <summary>
    /// The email message.
    /// </summary>
    public class EmailMessage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="EmailMessage"/> class.
        /// </summary>
        public EmailMessage()
        {
            this.ToAddresses = new List<EmailAddress>();
            this.BCCAddress = new List<EmailAddress>();
            this.CCAddress = new List<EmailAddress>();
            this.Attachments = new List<EmailAttachment>();
        }

        /// <summary>
        /// Gets or sets the to addresses.
        /// </summary>
        public List<EmailAddress> ToAddresses { get; set; }

        /// <summary>
        /// Gets or sets the bcc address.
        /// </summary>
        public List<EmailAddress> BCCAddress { get; set; }

        /// <summary>
        /// Gets or sets the cc address.
        /// </summary>
        public List<EmailAddress> CCAddress { get; set; }

        /// <summary>
        /// Gets or sets the subject.
        /// </summary>
        public string Subject { get; set; }

        /// <summary>
        /// Gets or sets the content.
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether priority.
        /// </summary>
        public bool? Priority { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether importance.
        /// </summary>
        public bool? Importance { get; set; }

        /// <summary>
        /// Gets or sets the attachments.
        /// </summary>
        public List<EmailAttachment> Attachments { get; set; }
    }
}