﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The provider profile info model.
    /// </summary>
    public class CallHistoryModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// Gets or sets the call status.
        /// </summary>
        public string CallStatus { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime? Date { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the user call status.
        /// </summary>
        public int UserCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the user call status name.
        /// </summary>
        public string UserCallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the user call status name.
        /// </summary>
        public string ShortName { get; set; }

        /// <summary>
        /// Gets or sets the user call status name.
        /// </summary>
        public string CallerShortName { get; set; }

        /// <summary>
        /// Gets or sets the user call status name.
        /// </summary>
        public string CallerRoleName { get; set; }

        /// <summary>
        /// Gets or sets the user call status name.
        /// </summary>
        public string CallerFullName { get; set; }
    }
}