﻿namespace Hims.Shared.UserModels.ChargeManagement
{
    /// <summary>
    /// The provider profile info model.
    /// </summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public int DepartmentId { get; set; }
        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the charge group identifier.
        /// </summary>
        /// <value>
        /// The charge group identifier.
        /// </value>
        public int ChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge group.
        /// </summary>
        /// <value>
        /// The name of the charge group.
        /// </value>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the old name of the charge group.
        /// </summary>
        /// <value>
        /// The old name of the charge group.
        /// </value>
        public int OldChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the op cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double? OpCost { get; set; }

        /// <summary>
        /// Gets or sets the repeat type identifier.
        /// </summary>
        /// <value>
        /// The repeat type identifier.
        /// </value>
        public int RepeatTypeId { get; set; }

        /// <summary>
        /// Gets or Sets the Modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }
    }
}