﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class EncountersLogModel
    {

        /// <summary>
        /// Gets or sets the encounter LogId.
        /// </summary>
        public int EncounterLogId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public int EncounterTypeId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type name.
        /// </summary>
        public string? EncounterTypeName { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }
        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the encounterLog code.
        /// </summary>
        public string LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the location id
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
        /// <summary>
        /// Gets or sets the Section.
        /// </summary>
        public string Section { get; set; }
    }
}
