﻿using System.Collections.Generic;
using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.FinalBill
{
    using System;
    using FinalBillServiceOrder = ServiceOrder;
    using FinalBillPackage = Package;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount type identifier.
        /// </summary>
        /// <value>
        /// The discount type identifier.
        /// </value>
        public DiscountType? DiscountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the discount details.
        /// </summary>
        /// <value>
        /// The discount details.
        /// </value>
        public double? DiscountDetails { get; set; }

        /// <summary>
        /// Gets or sets the final amount.
        /// </summary>
        /// <value>
        /// The final amount.
        /// </value>
        public double FinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the general records.
        /// </summary>
        /// <value>
        /// The general records.
        /// </value>
        public List<FinalBillServiceOrder.InsertModel> GeneralRecords { get; set; }

        /// <summary>
        /// Gets or sets the general records.
        /// </summary>
        /// <value>
        /// The general records.
        /// </value>
        public List<FinalBillServiceOrder.InsertModel> PharmacyRecords { get; set; }
        
        /// <summary>
        /// Gets or sets the package records.
        /// </summary>
        /// <value>
        /// The package records.
        /// </value>
        public List<FinalBillPackage.InsertModel> PackageRecords { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="FinalBill"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public short? RoleId { get; set; }
        /// <summary>
        /// Gets or sets the RollName.
        /// </summary>
        public string? RollName { get; set; }
        /// <summary>
        /// Gets or sets the FullName.
        /// </summary>
        public string? FullName { get; set; }

        public int? PatientId { get; set; }

        public int? LocationId { get; set; }
    }
}
