﻿namespace Hims.Shared.UserModels
{
    using Hims.Shared.Library.Enums;

    /// <summary> The homeopathy encounter modify model.</summary>
    public class HomeopathyEncounterModifyModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int HomeopathyId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public HomeopathyType Type { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }
    }
}